function [ DENSITY, INTENSITY, MTL, N, M, lx, ly] = gridcircularscanline( fractureShp, radius)

xsteps = 100;
ysteps = 76;

x = [fractureShp.X];
y = [fractureShp.Y];

maxx = max(x);
minx = min(x);
maxy = max(y);
miny = min(y);


% radius = 100; %(maxx-minx) / 10;
lx = linspace( minx, maxx, xsteps);
ly = linspace( miny, maxy, ysteps);

%[XI, YI] = meshgrid( lx, ly);

DENSITY = zeros(xsteps, ysteps);
INTENSITY = zeros(xsteps, ysteps);
MTL = zeros(xsteps, ysteps);

h = waitbar(0, 'please wait') ;

for x = 1 : xsteps,
    waitbar(x/xsteps);
    for y = 1:ysteps,
        
        [n, m] = circularscanline( fractureShp, [lx(x) ly(y)], radius);
        DENSITY( x, y) = m/(2*pi*(radius^2));
        INTENSITY(x, y) = n / (4*radius);
        MTL(x,y) = pi*0.5*radius *(n/m);
        N(x,y) = n;
        M(x,y) = m;
    end
end
close(h)
